// include the standard colors and textures
// ----------------------------------------
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "woods.inc"
#include "glass.inc"
#include "finish.inc"

// the objects
#include "tricycle_textures.inc"
#include "flooring.inc"
#include "tricycle.inc"
#include "ruban_cadeau.inc"
#include "cadeau_1.inc"
#include "cadeau_2.inc"
#include "cadeau_3.inc"
#include "cadeau_4.inc"
#include "cadeau_5.inc"
#include "card_label.inc"
#include "card_string.inc"

// using default setting from moray 2.5 
// because I'm running out of tiiiimmmee
// -------------------------------------
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 2.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

// setting camera and lightning first
// ----------------------------------

background { color rgb <0, 0, 0> }

//camera {
//	location <9.52, 24.67, -18.80>
//	look_at <0.00, 5.60, 0.27>
//}

camera {
	location <18, 15, 3.5>
	look_at <3, 6, -0.5>
    angle 50
}

light_source {
  <0, 40, 0>
  color rgb <1,1,1>
  area_light x*0.5, z*0.5, 4, 4
  //jitter 0.1
  spotlight
  point_at <-2, 1, 0.5>
  radius 19
  falloff 22
}

object {  flooring rotate x*-90 scale 0.8 }


